local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
        Asset( "ANIM", "anim/mayoi.zip" ),
		
		
}

local prefabs = {
	
}

local start_inv = 
{
	"saribackpack" }

local function updatestats(inst)
 
if GetClock():IsDusk() then
    
     inst.components.locomotor.walkspeed = 4
     inst.components.locomotor.runspeed = 6
    elseif GetClock():IsDay() and inst.components.sanity.current < 50 then

		local px,py,pz = GetPlayer().Transform:GetWorldPosition()
local ground
local x,z
repeat
x = math.random() * 660 - 50
z = math.random() * 660 - 50
ground = GetWorld().Map:GetTileAtPoint(x,0,z)
until not ((GetWorld().Map.IsWater and GetWorld().Map:IsWater(ground)) or ground == 1) 
TheCamera:Snap()
        TheFrontEnd:DoFadeIn(1)
GetPlayer().Transform:SetPosition(x,0,z) 
inst.components.talker:Say("Maybe I lost way again...")		
inst.components.locomotor.walkspeed = 6
	inst.components.locomotor.runspeed = 8
    elseif GetClock():IsNight() then
		inst.components.locomotor.walkspeed = 5
	inst.components.locomotor.runspeed = 7
		
	end
	end

local fn = function(inst)

	

	-- choose which sounds this character will play
	inst.soundsname = "mayoi"
	
	
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "mayoi.tex" )
	
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(120)
	inst.components.sanity:SetMax(100)
	
	
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1.2 * TUNING.WILSON_HUNGER_RATE
	
	-- Movement speed (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
	inst.components.sanity.neg_aura_mult = 1.3

inst:AddComponent("resurrectable")
TheInput:AddKeyUpHandler(KEY_SPACE, function()
inst.components.playercontroller:Enable(false)
inst.components.locomotor:Stop()
   inst.Physics:SetCollides(true)
   inst:DoTaskInTime(0.1, function()

        inst.AnimState:PlayAnimation("jump")
        inst.components.hunger:DoDelta(-3)
        inst.components.sanity:DoDelta(2)
        inst.Physics:SetMotorVelOverride(12,10,0) end )
   inst:DoTaskInTime(0.2, function()
        inst.Physics:ClearMotorVelOverride()
        inst.Physics:SetMotorVelOverride(12,0,0) end )
   inst:DoTaskInTime(0.3, function()
        inst.Physics:ClearMotorVelOverride()
        inst.Physics:SetMotorVelOverride(12,-10,0) end )
   inst:DoTaskInTime(0.5, function()
        inst.Physics:ClearMotorVelOverride()
        inst.components.locomotor:Stop()
        local pt = inst:GetPosition()
        inst.Transform:SetPosition(pt.x, 0, pt.z)

        local names = 
{"cutgrass","log","twigs","cutgrass","log","twigs","cutgrass","log","twigs","cutgrass","log","carrot","carrot","cutgrass","log","twigs"}
 if math.random()<.01 then
    inst.name = names[math.random(#names)]
    SpawnPrefab(inst.name).Transform:SetPosition(inst.Transform:GetWorldPosition())
    SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
end
        inst.Physics:SetCollides(true)
        inst.AnimState:PlayAnimation("idle")
 inst.components.playercontroller:Enable(true)
        inst.SoundEmitter:PlaySound("dontstarve/movement/bodyfall_dirt", "bodyfall") end )
end )

	
inst.components.health.absorb = 0.2
inst.components.combat.damagemultiplier = 0.8

    inst.components.combat.min_attack_period =0.4
local function OnAttacked(inst)
   local names = 
{"bedroll_furry","umbrella","goldnugget","tentaclespike","meat","dragonfruit","bandage","baconeggs","tallbirdegg","bandage","healingsalve","goldnugget","meat_dried","minerhat","icecream","icestaff","firestaff","sewing_kit","goldenshovel","goldenaxe","bedroll_furry","bandage","bandage","bandage","tophat","pumpkincookie","powcake","kabobs"}
 if math.random()<.09 then
    inst.name = names[math.random(#names)]
    SpawnPrefab(inst.name).Transform:SetPosition(inst.Transform:GetWorldPosition())
    SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
end
end
    inst:ListenForEvent("attacked", OnAttacked)

 inst:ListenForEvent( "dusktime", function() updatestats(inst) end , GetWorld())
    inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())
    inst:ListenForEvent( "nighttime", function() updatestats(inst) end , GetWorld())
	updatestats(inst)

end
return MakePlayerCharacter("mayoi", prefabs, assets, fn, start_inv)
